<?php
/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

defined('_JEXEC') or die;
include_once(JPATH_ADMINISTRATOR . '/components/com_extensionsmanagerck/helpers/installer.php');

class ExtensionsmanagerckController extends \Joomla\CMS\MVC\Controller\BaseController
{
	/**
	 * @var        string    The default view.
	 */
	protected $default_view = 'extensions';

	/*
	 * Load the file from the url
	 */
	public function ajaxGetFile() {
		$app = \Extensionsmanagerck\CKFof::getApplication();

		$url = $this->input->get('url', '', 'string');
		$reload = $this->input->get('reload', 0, 'string');

		$key = 'com_extensionsmanagerck_' . $url;
		if (! ($data = $app->getUserState($key)) || ($reload !== 0 && ($reload == 1 || $reload == $url)) ) {
			$data = $this->loadFileFromUrl($url);
			$app->setUserState($key, $data);
		}

		echo $data;
		exit();
	}

	/* 
	 * Install the extension
	 */
	public function ajaxInstallExt() {
		$installer = new ExtensionsmanagerckInstaller;
		$installer->install();
		
		$this->getMessages();
		exit;
	}

	/* 
	 * Check how to get the file content from the url
	 */
	private function loadFileFromUrl($url) {
		if (function_exists('file_get_contents')) {  
			$result = @file_get_contents($url);  
		} 
		// look for curl
		if ($result == '' && extension_loaded('curl')) {
			$ch = curl_init();  
			$timeout = 30;  
			curl_setopt($ch, CURLOPT_URL, $url);  
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
			curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
			curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
			curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);  
			$result = curl_exec($ch);  
			curl_close($ch);  
		}

		return $result;
	}

	public function getMessages() {
		$systemMessages = \Extensionsmanagerck\CKFof::getApplication()->getMessageQueue();

		if (empty($systemMessages)) return;

		foreach ($systemMessages as $m) {
			$text = $m['message'];
			$type = isset($m['type']) ? ' alert-' . $m['type'] : '';
			if ($text) {
			?>
			<div class="alert<?php echo $type ?>"><?php echo $text ?></div>
			<?php
			}
		}
	}
}
