<?php
/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

class ExtensionsmanagerckInstaller extends \Extensionsmanagerck\CKObject {

	/**
	 * Install an extension from either folder, url or upload.
	 *
	 * @return  boolean result of install.
	 *
	 * @since   1.5
	 */
	public function install()
	{
		// $this->setState('action', 'install');

		// Set FTP credentials, if given.
		// \Joomla\CMS\Application\CliApplicationentHelper::setCredentialsFromRequest('ftp');
		$app = \Extensionsmanagerck\CKFof::getApplication();

		// Load installer plugins for assistance if required:
		\Joomla\CMS\Plugin\PluginHelper::importPlugin('installer');

		$package = null;

		// This event allows an input pre-treatment, a custom pre-packing or custom installation.
		// (e.g. from a JSON description).
		// $results = $this->triggerEvent('onInstallerBeforeInstallation');

		// if (in_array(true, $results, true))
		// {
			// return true;
		// }

		// if (in_array(false, $results, true))
		// {
			// return false;
		// }

		// $installType = $app->input->getWord('installtype');
		$installType = 'url';

		if ($package === null)
		{
			switch ($installType)
			{
				case 'folder':
					// Remember the 'Install from Directory' path.
					$app->getUserStateFromRequest($this->_context . '.install_directory', 'install_directory');
					$package = $this->_getPackageFromFolder();
					break;

				case 'upload':
					$package = $this->_getPackageFromUpload();
					break;

				case 'url':
					$package = $this->_getPackageFromUrl();
					break;

				default:
					$app->setUserState('com_installer.message', \Extensionsmanagerck\CKText::_('COM_INSTALLER_NO_INSTALL_TYPE_FOUND'));

					return false;
					break;
			}
		}

		// This event allows a custom installation of the package or a customization of the package:
		// $results = $this->triggerEvent('onInstallerBeforeInstaller', array($this, &$package));

		// if (in_array(true, $results, true))
		// {
			// return true;
		// }

		// if (in_array(false, $results, true))
		// {
			// if (in_array($installType, array('upload', 'url')))
			// {
				// \Joomla\CMS\Installer\InstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);
			// }

			// return false;
		// }

		// Was the package unpacked?
		if (!$package || !$package['type'])
		{
			if (in_array($installType, array('upload', 'url')))
			{
				\Joomla\CMS\Installer\InstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);
			}

			$app->enqueueMessage(\Extensionsmanagerck\CKText::_('COM_INSTALLER_UNABLE_TO_FIND_INSTALL_PACKAGE'), 'error');

			return false;
		}

		// Get an installer instance.
		$installer = \Joomla\CMS\Installer\Installer::getInstance();

		// Install the package.
		if (!$installer->install($package['dir']))
		{
			// There was an error installing the package.
			$msg = \Extensionsmanagerck\CKText::sprintf('COM_INSTALLER_INSTALL_ERROR', \Extensionsmanagerck\CKText::_('COM_INSTALLER_TYPE_TYPE_' . strtoupper($package['type'])));
			$result = false;
			$msgType = 'error';
		}
		else
		{
			// Package installed sucessfully.
			$msg = \Extensionsmanagerck\CKText::sprintf('COM_INSTALLER_INSTALL_SUCCESS', \Extensionsmanagerck\CKText::_('COM_INSTALLER_TYPE_TYPE_' . strtoupper($package['type'])));
			$result = true;
			$msgType = 'message';
		}

		// This event allows a custom a post-flight:
		// $this->triggerEvent('onInstallerAfterInstaller', array($this, &$package, $installer, &$result, &$msg));

		// Set some model state values.
		$app = \Extensionsmanagerck\CKFof::getApplication();
		$app->enqueueMessage($msg, $msgType);
		// $this->setState('name', $installer->get('name'));
		// $this->setState('result', $result);
		$app->setUserState('com_installer.message', $installer->message);
		$app->setUserState('com_installer.extension_message', $installer->get('extension_message'));
		$app->setUserState('com_installer.redirect_url', $installer->get('redirect_url'));

		// Cleanup the install files.
		if (!is_file($package['packagefile']))
		{
			$config = \Joomla\CMS\Factory::getConfig();
			$package['packagefile'] = $config->get('tmp_path') . '/' . $package['packagefile'];
		}

		\Joomla\CMS\Installer\InstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);

		return $result;
	}

	/**
	 * Install an extension from a URL.
	 *
	 * @return  Package details or false on failure.
	 *
	 * @since   1.5
	 */
	protected function _getPackageFromUrl()
	{
		$input = \Extensionsmanagerck\CKFof::getApplication()->input;

		// Get the URL of the package to install.
		$url = $input->getString('install_url');
// $url = 'http://www.joomlack.fr/index.php?option=com_dms&amp;task=doc_download&amp;id=59&amp;updater=true';
// $url = 'https://translations.joomlack.fr/index.php?option=com_ctransifex&task=download.zip&language=nl-NL&project=5';
// var_dump($url);
		// Did you give us a URL?
		if (!$url)
		{
			JError::raiseWarning('', \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_ENTER_A_URL'));

			return false;
		}

		// Handle updater XML file case:
		if (preg_match('/\.xml\s*$/', $url))
		{
			jimport('joomla.updater.update');
			$update = new \Joomla\CMS\Updater\Update;
			$update->loadFromXml($url);
			$package_url = trim($update->get('downloadurl', false)->_data);

			if ($package_url)
			{
				$url = $package_url;
			}

			unset($update);
		}

		// Download the package at the URL given.
		$p_file = \Joomla\CMS\Installer\InstallerHelper::downloadPackage($url);
// var_dump($p_file);die;
		// Was the package downloaded?
		if (!$p_file)
		{
			JError::raiseWarning('', \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_INVALID_URL'));

			return false;
		}

		$config   = \Joomla\CMS\Factory::getConfig();
		$tmp_dest = $config->get('tmp_path');

		// Unpack the downloaded package file.
		$package = \Joomla\CMS\Installer\InstallerHelper::unpack($tmp_dest . '/' . $p_file, true);

		return $package;
	}

	/**
	 * Works out an installation package from a HTTP upload.
	 *
	 * @return package definition or false on failure.
	 */
	protected function _getPackageFromUpload()
	{
		// Get the uploaded file information.
		$input    = \Extensionsmanagerck\CKFof::getApplication()->input;

		// Do not change the filter type 'raw'. We need this to let files containing PHP code to upload. See \Joomla\CMS\Input\Files::get.
		$userfile = $input->files->get('install_package', null, 'raw');

		// Make sure that file uploads are enabled in php.
		if (!(bool) ini_get('file_uploads'))
		{
			JError::raiseWarning('', \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLFILE'));

			return false;
		}

		// Make sure that zlib is loaded so that the package can be unpacked.
		if (!extension_loaded('zlib'))
		{
			JError::raiseWarning('', \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLZLIB'));

			return false;
		}

		// If there is no uploaded file, we have a problem...
		if (!is_array($userfile))
		{
			JError::raiseWarning('', \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_NO_FILE_SELECTED'));

			return false;
		}

		// Is the PHP tmp directory missing?
		if ($userfile['error'] && ($userfile['error'] == UPLOAD_ERR_NO_TMP_DIR))
		{
			JError::raiseWarning(
				'',
				\Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLUPLOADERROR') . '<br />' . \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_WARNINGS_PHPUPLOADNOTSET')
			);

			return false;
		}

		// Is the max upload size too small in php.ini?
		if ($userfile['error'] && ($userfile['error'] == UPLOAD_ERR_INI_SIZE))
		{
			JError::raiseWarning(
				'',
				\Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLUPLOADERROR') . '<br />' . \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_WARNINGS_SMALLUPLOADSIZE')
			);

			return false;
		}

		// Check if there was a different problem uploading the file.
		if ($userfile['error'] || $userfile['size'] < 1)
		{
			JError::raiseWarning('', \Extensionsmanagerck\CKText::_('COM_INSTALLER_MSG_INSTALL_WARNINSTALLUPLOADERROR'));

			return false;
		}

		// Build the appropriate paths.
		$config   = \Joomla\CMS\Factory::getConfig();
		$tmp_dest = $config->get('tmp_path') . '/' . $userfile['name'];
		$tmp_src  = $userfile['tmp_name'];

		// Move uploaded file.
		jimport('joomla.filesystem.file');
		\Extensionsmanagerck\CKFile::upload($tmp_src, $tmp_dest, false, true);

		// Unpack the downloaded package file.
		$package = \Joomla\CMS\Installer\InstallerHelper::unpack($tmp_dest, true);

		return $package;
	}

	public function triggerEvent($name, $e = array()) {
		if (version_compare(JVERSION,'4') < 1) {
			$dispatcher = JEventDispatcher::getInstance();
			return $dispatcher->trigger($name, $e);
		} else {
			return \Extensionsmanagerck\CKFof::getApplication()->triggerEvent($name, $e);
		}
	}
}