<?php
/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

defined('_JEXEC') or die;

class ExtensionsmanagerckViewExtensions extends \Joomla\CMS\MVC\View\HtmlView
{
	protected $items;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->items = $this->get('Items');

		// Check for errors.
		if (! empty($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{ 

		
		// $state	= $this->get('State');
		// $canDo	= \Joomla\CMS\Help\HelperContent::getActions('com_modules');
		$user  = \Joomla\CMS\Factory::getUser();

		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Extensionsmanagerck\CKText::_('COM_EXTENSIONSMANAGERCK'), 'extensionsmanagercktitle');

		if ($user->authorise('core.admin', 'com_installer') && $user->authorise('core.manage', 'com_installer')) {
			// \Joomla\CMS\HTML\HTMLHelper::_('bootstrap.modal', 'collapseModal');
			// $title = \Extensionsmanagerck\CKText::_('JTOOLBAR_BATCH');

			// Instantiate a new \Joomla\CMS\Layout\FileLayout instance and render the batch button
			// $layout = new \Joomla\CMS\Layout\FileLayout('joomla.toolbar.batch');

			// add the buttons to the toolbar
			$dhtml = '<button class="btn btn-small" onclick="ckloadAllData(\'1\')">
						<span class="icon-reload">&nbsp;</span>  ' . \Extensionsmanagerck\CKText::_('CK_RELOAD') . '
					</button>';
			$bar->appendButton('Custom', $dhtml, 'ckloadAllData');
			// add the buttons to the toolbar
			$dhtml = '<a class="btn btn-small" href="' . \Extensionsmanagerck\CKUri::base(true) . '/index.php?option=com_extensionsmanagerck&view=languages">
						<span class="icon-list">&nbsp;</span>  ' . \Extensionsmanagerck\CKText::_('CK_LANGUAGE_PACKS') . '
					</a>';
			$bar->appendButton('Custom', $dhtml, 'ckloadAllData');
			

			// $dhtml = '<button class="btn btn-small" onclick="ckTogglePreview()">
						// <span class="icon-eye-open icon-eye">&nbsp;</span>  ' . \Extensionsmanagerck\CKText::_('CK_SHOW_PREVIEW') . '
					// </button>';
			// $bar->appendButton('Custom', $dhtml, 'showpreview');

			// $dhtml = '<button class="btn btn-small" onclick="">
						// <span class="icon-copy">&nbsp;</span>  ' .  \Extensionsmanagerck\CKText::_('CK_COPY') . '
					// </button>';
			// $bar->appendButton('Custom', $dhtml, 'copy');
		}
/*
		if ($canDo->get('core.create'))
		{

		}

		if ($canDo->get('core.edit'))
		{

		}

		if ($canDo->get('core.create'))
		{

		}

		if ($canDo->get('core.edit.state'))
		{

		}

		if ($state->get('filter.state') == -2 && $canDo->get('core.delete'))
		{

		} elseif ($canDo->get('core.edit.state'))
		{

		}

		if ($canDo->get('core.admin'))
		{
			\Joomla\CMS\Toolbar\ToolbarHelper::preferences('com_modules');
		}
		\Joomla\CMS\Toolbar\ToolbarHelper::help('JHELP_EXTENSIONS_MODULE_MANAGER');*/
	}

	/**
	 * List the actions that can be performed.
	 *
	 * return Object - the action list
	 */
	protected function getActions()
	{
		$user = \Joomla\CMS\Factory::getUser();
		$result = new \Extensionsmanagerck\CKObject;
		$ext = 'com_extensionsmanagerck';

		$actions = array(
			'core.admin', 'core.manage',
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $ext));
		}

		return $result;
	}
}
