<?php
/**
 * @name		Extensions Manager CK
 * @package		com_extensionsmanagerck
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

defined('_JEXEC') or die;

class ExtensionsmanagerckViewLanguages extends \Joomla\CMS\MVC\View\HtmlView
{
	protected $items;

	/**
	 * Display the view
	 */
	public function display($tpl = null)
	{
		$this->items = $this->get('Items');

		// Check for errors.
		if (! empty($errors = $this->get('Errors')))
		{
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}

		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar()
	{ 

		$user  = \Joomla\CMS\Factory::getUser();

		// Get the toolbar object instance
		$bar = \Joomla\CMS\Toolbar\Toolbar::getInstance('toolbar');

		\Joomla\CMS\Toolbar\ToolbarHelper::title(\Extensionsmanagerck\CKText::_('COM_EXTENSIONSMANAGERCK'), 'extensionsmanagercktitle');

		if ($user->authorise('core.admin', 'com_installer') && $user->authorise('core.manage', 'com_installer')) {
			$dhtml = '<a class="btn btn-small" href="' . \Extensionsmanagerck\CKUri::base(true) . '/index.php?option=com_extensionsmanagerck">
						<span class="icon-list">&nbsp;</span>  ' . \Extensionsmanagerck\CKText::_('CK_EXTENSIONS') . '
					</a>';
			$bar->appendButton('Custom', $dhtml, 'ckloadAllData');
		}

	}

	/**
	 * List the actions that can be performed.
	 *
	 * return Object - the action list
	 */
	protected function getActions()
	{
		$user = \Joomla\CMS\Factory::getUser();
		$result = new \Extensionsmanagerck\CKObject;
		$ext = 'com_extensionsmanagerck';

		$actions = array(
			'core.admin', 'core.manage',
		);

		foreach ($actions as $action)
		{
			$result->set($action, $user->authorise($action, $ext));
		}

		return $result;
	}
}
