<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2018. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

// no direct access
defined('_JEXEC') or die;
// load the lightbox
MobilemenuckHelper::loadCkbox();

// check the joomla! version
if (version_compare(JVERSION, '3.0.0') > 0) {
	$jversion = '3';
} else {
	$jversion = '2';
}

$doc = \Mobilemenuck\CKFof::getDocument();
$doc->addStylesheet(MOBILEMENUCK_MEDIA_URI . '/assets/ckframework.css');
// vars
$input	= \Mobilemenuck\CKFof::getApplication()->input;
//$modal = $input->get('layout', '') == 'modal' ? true : false;

$user = \Joomla\CMS\Factory::getUser();
$userId = $user->get('id');
$isModal = $input->get('modal', '', 'string') == '1';
$function = $input->get('returnFunc', 'ckSelectStyle', 'string');
$appendUrl = $isModal ? '&modal=1&tmpl=component' : '';
$style = $isModal ? 'style="padding:10px;"' : '';

// for ordering
$listOrder = $this->state->get('filter_order', 'a.id');
$listDirn = $this->state->get('filter_order_Dir', 'ASC');
$filter_search = $this->state->get('filter_search', '');
$limitstart = $this->state->get('limitstart', 0);
$limit = $this->state->get('limit', 20);
?>
<style>
	body.contentpane {
		padding: 125px 10px;
	}
	.ordering-select {
		margin-left: auto;
	}
	joomla-toolbar-button {
		margin: 5px;
	}
</style>
<div class="ckadminarea " style="background:#fff; padding: 10px;">
<form action="<?php echo \Joomla\CMS\Router\Route::_('index.php?option=com_mobilemenuck&view=styles'.$appendUrl); ?>" method="post" name="adminForm" id="adminForm" <?php echo $style ?>>
	<?php if ($isModal) { ?>
	<div id="ckheader">
		<div class="ckheaderlogo"><a href="https://www.joomlack.fr" target="_blank"><img title="JoomlaCK" src="https://media.joomlack.fr/images/logo_ck_white.png" width="35" height="35"></a></div>
		<div class="ckheadermenu">
			<div class="ckheadertitle">MOBILE MENU CK - <?php echo \Mobilemenuck\CKText::_('CK_STYLES'); ?></div>
		</div>
	</div>
	<div id="cktoolbar-fixed">
		<?php echo $this->toolbar->render(); ?>
	</div>
	<?php } ?>
	<div id="filter-bar" class="btn-toolbar input-group">
		<div class="filter-search btn-group pull-left">
			<label for="filter_search" class="element-invisible"><?php echo \Mobilemenuck\CKText::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo \Mobilemenuck\CKText::_('JSEARCH_FILTER'); ?>" value="<?php echo addslashes($this->state->get('filter_search')); ?>" class="cktip form-control" title="" />
		</div>
		<div class="input-group-append btn-group pull-left hidden-phone">
			<button type="submit" class="btn btn-primary cktip" title="<?php echo \Mobilemenuck\CKText::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i><?php echo ($jversion === '2' ? \Mobilemenuck\CKText::_('JSEARCH_FILTER_SUBMIT') : ''); ?></button>
			<button type="button" class="btn btn-secondary cktip" title="<?php echo \Mobilemenuck\CKText::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value = '';
					this.form.submit();"><i class="icon-remove"></i><?php echo ($jversion === '2' ? \Mobilemenuck\CKText::_('JSEARCH_FILTER_CLEAR') : ''); ?></button>
		</div>
		<?php if ($jversion === '3') { ?>
		<div class="btn-group pull-right hidden-phone ordering-select">
			<label for="limit" class="element-invisible"><?php echo \Mobilemenuck\CKText::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
			<?php echo $this->pagination->getLimitBox(); ?>
		</div>
		<?php } ?>
	</div>
	<table class="cktable cktable-striped cktable-single-bordered" id="itemsList">
		<thead>
			<tr>
				<?php //if (! $isModal) { ?>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" title="<?php echo \Mobilemenuck\CKText::_('JGLOBAL_CHECK_ALL'); ?>" value="" onclick="Joomla.checkAll(this)" />
				</th>
				<?php //} ?>
				<th class='left'>
					<?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'JGLOBAL_TITLE', 'a.name', $listDirn, $listOrder); ?>
				</th>
				<th width="1%" class="nowrap">
					<?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
				</th>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="10">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
			<?php
			foreach ($this->items as $i => $item) :
				$link = 'index.php?option=com_mobilemenuck&view=style&tmpl=component&id=' . $item->id;
				$name = $item->name ? $item->name : 'style' . $item->id;
				?>
				<tr class="row<?php echo $i % 2; ?>">
					<?php //if (! $isModal) { ?>
					<td class="center">
						<?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->id); ?>
					</td>
					<?php //} ?>
					<td>
						<?php if ($isModal) { ?>
						<a href="javascript:void(0)" onclick="window.parent.<?php echo $function ?>('<?php echo $item->id; ?>', '<?php echo $name; ?>')"><?php echo $name; ?></a>
						<?php /*<a href="<?php echo \Mobilemenuck\CKUri::root(true) . '/administrator/' . $link ?>" class="ckbutton"><?php echo \Mobilemenuck\CKText::_('CK_EDIT'); ?></a>*/ ?>
						<?php } else { ?>
						<a onclick="CKBox.open({handler:'iframe', fullscreen: true, url:'<?php echo \Mobilemenuck\CKUri::root(true) . '/administrator/' . $link ?>'})" href="#"><?php echo $name; ?></a>
						<?php } ?>
					</td>
					<td class="center">
					<?php echo (int) $item->id; ?>
					</td>
				</tr>
			<?php endforeach; ?>
		</tbody>
	</table>
	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<input type="hidden" name="state_request" value="1" />
		<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
	</div>
</form>
</div>