<?php
/**
 * @name		Mobile Menu CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */

// No direct access
defined('_JEXEC') or die;

use Mobilemenuck\CKController;
use Mobilemenuck\CKFof;

/**
 * Style controller class.
 */
class MobilemenuckControllerMenu extends CKController {

	function __construct() {
		$this->redirect = MOBILEMENUCK_ADMIN_GENERAL_URL . '&view=menus';
		parent::__construct();
	}

	public function edit($id = null, $appendUrl = '') {
		$editIds = $this->input->get('cid', null, 'array');
		if (! empty($editIds)) {
			$editId = (int) $editIds[0];
		} else {
			$editId = (int) $this->input->get('id', null, 'int');
		}

		// Redirect to the edit screen.
		Mobilemenuck\CKFof::redirect(MOBILEMENUCK_ADMIN_URI . '&view=menu&layout=edit&id=' . $editId);
	}

	public function delete() {
		$app = \Joomla\CMS\Factory::getApplication();
		$editIds = $this->input->get('cid', null, 'array');
		if (count($editIds)) {
			$id = (int) $editIds[0];
		} else {
			$id = (int) $this->input->get('id', null, 'int');
		}
		$model = $this->getModel();
		if ($model->delete($id)) {
			$msg = \Joomla\CMS\Language\Text::_('Item deleted with success');
		} else {
			$msg = \Joomla\CMS\Language\Text::_('Error : Item not deleted');
		}

		// Redirect to the edit screen.
		Mobilemenuck\CKFof::redirect('index.php?option=com_mobilemenuck&view=items', $msg);
	}

	public function save($key = null, $urlVar = null) {
		$app = \Joomla\CMS\Factory::getApplication();
		if ($app->input->get('method','', 'cmd') == 'ajax') {
			// Check for request forgeries.
			\Joomla\CMS\Session\Session::checkToken('get') or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));
		} else {
			// Check for request forgeries.
			\Joomla\CMS\Session\Session::checkToken() or jexit(\Joomla\CMS\Language\Text::_('JINVALID_TOKEN'));
		}
		
		// $task = $this->getTask();

		// Initialise variables.
		
		// $model = $this->getModel('Menu', 'MobilemenuckModel');

		$appendToUrl = $app->input->get('tmpl') ? '&tmpl=' . $app->input->get('tmpl') : '';
		$layout = $app->input->get('layout') == 'modal' ? '&layout=modal' : '&layout=edit';

		// Get the user data.
		$data = $app->input->getArray($_POST);
		$data['params']['beforetext'] = $_POST['params']['beforetext'];
		$data['params']['aftertext'] = $_POST['params']['aftertext'];

		// Attempt to save the data.
		$model = $this->getModel();
		$return = $model->save($data);

		// Check for errors.
		if ($return === false) {
			// Save the data in the session.
			// $app->setUserState('com_mobilemenuck.edit.menu.data', $data);

			// Redirect back to the edit screen.
			// $id = (int) $app->getUserState('com_mobilemenuck.edit.menu.id');
			$app->enqueueMessage(\Joomla\CMS\Language\Text::sprintf('Save failed', $model->getError()), 'warning');
			CKFof::redirect('index.php?option=com_mobilemenuck&view=menu&task=menu.edit'.$layout.'&id=' . $data['id'] . $appendToUrl);
			return false;
		}


		// Check in the profile.
		// if ($return) {
			// $model->checkin($return);
		// }

		// Clear the profile id from the session.
		// $app->setUserState('com_mobilemenuck.edit.menu.id', null);

		// Redirect to the list screen.
		$app->enqueueMessage(\Joomla\CMS\Language\Text::_('Item saved successfully'));
		
		switch ($task)
		{
			case 'apply':
			default:
				// Set the record data in the session.
				// $this->holdEditId($context, $recordId);
				// $app->setUserState($context . '.data', null);
				$model->checkout($return);

				// Redirect back to the edit screen.
				CKFof::redirect('index.php?option=com_mobilemenuck&task==menu.edit&id=' . $return . $appendToUrl);
				break;
			case 'saveclose':
				// Clear the record id and data from the session.
				// $this->releaseEditId($context, $recordId);
				// $app->setUserState($context . '.data', null);

				// Redirect to the list screen.
				CKFof::redirect('index.php?option=com_mobilemenuck&view=items');
				break;
		}
		

		// Flush the data from the session.
		// $app->setUserState('com_mobilemenuck.edit.page.data', null);
	}

	/**
	 * copy an existing page
	 * @return void
	 */
	function copy() {
		$model = $this->getModel('Menu', 'MobilemenuckModel');
		$input = \Joomla\CMS\Factory::getApplication()->input;
		$cid = $input->get('cid', '', 'array');
//		$input->set('id', (int) $cid[0]);
		if (!$model->copy((int) $cid[0])) {
			$msg = \Joomla\CMS\Language\Text::_('CK_COPY_ERROR');
			$type = 'error';
		} else {
			$msg = \Joomla\CMS\Language\Text::_('CK_COPY_SUCCESS');
			$type = 'message';
		}

		$this->setRedirect('index.php?option=com_mobilemenuck&view=items', $msg, $type);
	}

	function cancel() {
		$this->setRedirect('index.php?option=com_mobilemenuck&view=items');
	}
}