<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

defined('_JEXEC') || exit();

use Joomla\CMS\Factory;
use Joomla\CMS\Uri\Uri;
use Joomla\CMS\Version;

class plgsystembfnetworkInstallerScript
{
    /**
     * @return bool
     */
    public function preflight($type, $parent)
    {
        return true;
    }

    /**
     * @return bool
     */
    public function uninstall()
    {
        return true;
    }

    /**
     * Pass request to our abstracted out function.
     *
     * @return bool
     */
    public function update($parent)
    {
        return true;
    }

    /**
     * Pass request to our abstracted out function.
     */
    public function install($parent)
    {
        $this->registerSiteToMyJoomla('install');
    }

    /**
     * Send the most basic information back to mySites service so that we can register your site, after which we use a
     * dedicated secure connection through our connector.
     *
     * Some people call this "calling home" which has a negative reputation However the whole premise of the SasS
     * mySites.guru is an active connection between your site and our service so this is perfectly acceptable and lets
     * us know your site has a connector installed, so we can continue with the installation/connection process
     *
     * @param string $type update|install
     */
    public function registerSiteToMyJoomla($type)
    {
        $config  = Factory::getApplication()->getConfig();
        $version = new Version();

        // init our data holder...
        $data = new stdClass();

        // Is this an installation or an update
        $data->type = $type;

        /*
         * Get the friendly name of the website
         * Bloody Joomla version issues here too...
         */
        if (method_exists($config, 'getValue')) { //Old Joomla Versions
            $data->friendlyname = $config->getValue('config.sitename');
        } else {
            $data->friendlyname = $config->get('sitename');
        }

        // Get Joomla's Site URL
        $data->siteurl = str_replace('/administrator/', '/', (string) URI::base());

        // get Joomla's version number
        $data->version = $version->getShortVersion();

        /*
         * Check for our version file in two locations, again Joomla being a pain and changing the paths in 2.5.0+
         */
        if (file_exists('../plugins/system/bfnetwork/VERSION')) {
            $data->connectorversion = file_get_contents('../plugins/system/bfnetwork/VERSION');
        } elseif (file_exists('../plugins/system/bfnetwork/bfnetwork/VERSION')) {
            $data->connectorversion = file_get_contents('../plugins/system/bfnetwork/bfnetwork/VERSION');
        }

        /*
         * Get the has form the URL, crazy way to do it for maximum compatibility with
         * crappy servers!
         *
         * @todo test on all versions of Joomla
         */
        if (count($_FILES) && array_key_exists('install_package', $_FILES['install_package'])) { // Install by Zip file Upload
            $data->hash = trim(str_replace(['connector_',
                '(1)',
                '(2)',
                '(3)',
                '(4)',
                '(5)',
                '.zip', ], '', (string) $_FILES['install_package']['name']));
        } elseif (array_key_exists('install_url', $_POST)) { // Install by Install URL Pasted
            $data->hash = str_replace(
                [
                    'https://dev.mysites.guru/register/site/connect/',
                    'https://staging.mysites.guru/register/site/connect/',
                    'https://manage.mysites.guru/register/site/connect/',
                ],
                '',
                (string) $_POST['install_url']
            );
        } else {
            if (count($_FILES) && array_key_exists('install_package', $_FILES)) { // Install by Zip file Upload
                $data->hash = trim(str_replace(['connector_',
                    '(1)',
                    '(2)',
                    '(3)',
                    '(4)',
                    '(5)',
                    '.zip', ], '', (string) $_FILES['install_package']['name']));
            }
        }

        /*
         *  If in local development which developing mySites.guru services
         *  If developing we want to see what happens instead of having it happen in the background :)
         */
        if ('local' === getenv('APPLICATION_ENV') && ('127.0.0.1' === $_SERVER['REMOTE_ADDR'] || '::1' === $_SERVER['REMOTE_ADDR'])) {
            $registerUrl = 'https://dev.mysites.guru/register/site/yooohooo/';
            $url         = $registerUrl . base64_encode(json_encode($data, JSON_THROW_ON_ERROR));

            echo '<a href="' . $url . '">TEST</a>';
            echo json_encode($data, JSON_THROW_ON_ERROR);
            echo var_dump(str_replace(['connector_',
                '(1)',
                '(2)',
                '(3)',
                '(4)',
                '(5)',
                '.zip', ], '', (string) $_FILES['install_package']['name']));
            exit;
        } else {
            $registerUrl = 'https://manage.mysites.guru/register/site/yooohooo/';

            $url = trim($registerUrl . base64_encode(json_encode($data, JSON_THROW_ON_ERROR)));

            $options = [
                'http' => [
                    'method' => 'GET',
                    'header' => "Accept-language: en\r\n" .
                        'User-Agent: ' . $_SERVER['HTTP_HOST'] . "\r\n",
                ],
            ];

            $context = stream_context_create($options);

            // get the data from the request
            $ok = @file_get_contents($url, false, $context);

            /*
             * ** CRAPPY SERVER ALERT ** CRAPPY SERVER ALERT ** CRAPPY SERVER ALERT **
             */
            if (! $ok) {
                $ch = curl_init();

                // Set up bare minimum CURL Options needed for mySites.guru
                curl_setopt($ch, \CURLOPT_SSL_VERIFYPEER, true);
                curl_setopt($ch, \CURLOPT_HEADER, false);
                curl_setopt($ch, \CURLOPT_URL, $url);
                curl_setopt($ch, \CURLOPT_RETURNTRANSFER, true);
                curl_setopt($ch, \CURLOPT_USERAGENT, $_SERVER['HTTP_HOST']);

                // Attempt to download using CURL and CURLOPT_SSL_VERIFYPEER set to TRUE
                $ok = curl_exec($ch);

                // Did we succeed in getting something?
                if (! $ok) {
                    /*
                     * ** CRAPPY SERVER ALERT ** CRAPPY SERVER ALERT ** CRAPPY SERVER ALERT **
                     *
                     * Ok try without validation of the SSL (gulp) but this is needed on some servers without a pem file
                     * and we need to be compatible as possible - even on crappy webhosts when they need us most ;-(
                     */
                    curl_setopt($ch, \CURLOPT_SSL_VERIFYPEER, false);

                    //  Second Attempt to download using CURL and CURLOPT_SSL_VERIFYPEER set to FALSE (gulp)
                    curl_exec($ch);
                }

                curl_close($ch);
            }

            if (! $ok) {
                echo 'We could not auto register to mySites.guru so you will have to click the manual check button on the awaiting mySites.guru connection screen';
            }
        }
    }

    /**
     * Pass request to our abstracted out function.
     */
    public function postflight($type, $parent)
    {
        $this->registerSiteToMyJoomla($type);
    }
}
