/* jce - 2.9.98 | 2026-01-27 | https://www.joomlacontenteditor.net | Source: https://github.com/widgetfactory/jce | Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
!function($) {
    function mimeFromExt(url) {
        return {
            jpg: "image/jpeg",
            jpeg: "image/jpeg",
            png: "image/png",
            gif: "image/gif",
            webp: "image/webp",
            apng: "image/apng",
            mp4: "video/mp4",
            m4v: "video/x-m4v",
            ogg: "audio/ogg",
            ogv: "video/ogg",
            webm: "video/webm",
            mp3: "audio/mpeg",
            wav: "audio/wav",
            pdf: "application/pdf",
            zip: "application/zip",
            tar: "application/x-tar",
            doc: "application/msword",
            docx: "application/vnd.openxmlformats-officedocument.wordprocessingml.document",
            dot: "application/msword",
            dotx: "application/vnd.openxmlformats-officedocument.wordprocessingml.template",
            xls: "application/vnd.ms-excel",
            xlsx: "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet",
            ppt: "application/vnd.ms-powerpoint",
            pps: "application/vnd.ms-powerpoint",
            pptx: "application/vnd.openxmlformats-officedocument.presentationml.presentation",
            ppsx: "application/vnd.openxmlformats-officedocument.presentationml.slideshow",
            odt: "application/vnd.oasis.opendocument.text",
            odp: "application/vnd.oasis.opendocument.presentation",
            ods: "application/vnd.oasis.opendocument.spreadsheet",
            odg: "application/vnd.oasis.opendocument.graphics"
        }[url.split(".").pop().toLowerCase()] || "";
    }
    function createPreview(field, url, mimeType) {
        var el;
        field && field.previewElement && (field.previewElement.innerHTML = "", (mimeType = mimeType && 0 !== mimeType.indexOf("text/") ? mimeType : mimeFromExt(url)) && 0 === mimeType.indexOf("image/") ? ((el = document.createElement("img")).src = url, 
        el.alt = "Preview") : mimeType && 0 === mimeType.indexOf("video/") ? ((el = document.createElement("video")).preload = "metadata", 
        el.controls = !0, el.src = url, el.type = mimeType) : mimeType && 0 === mimeType.indexOf("audio/") ? ((el = document.createElement("audio")).preload = "none", 
        el.controls = !0, el.src = url, el.type = mimeType) : ((el = document.createElement("object")).data = url, 
        el.type = mimeType || "application/octet-stream"), field.previewElement.appendChild(el));
    }
    function isAdmin(value) {
        return value && -1 != value.indexOf("/administrator/");
    }
    function updateMediaUrl(row, options) {
        $(row).find(".field-media-wrapper").add(row).each(function() {
            var $inp = $(this).find(".field-media-input"), id = $inp.attr("id");
            if ($inp.attr("disabled")) return !0;
            if (!id) return !0;
            id = id.replace("rowX", "row" + $(row).index()), $inp.attr("id", id), 
            $(this).addClass("wf-media-wrapper");
            var extensions, dataUrl = $(this).data("url") || $(this).attr("url") || "", $linkBtn = $(this).find('a[href*="index.php?option=com_media"].modal.btn'), params = function(url) {
                var data = {};
                return url && (url = url.substring(url.indexOf("?") + 1), $.each(url.replace(/\+/g, " ").split("&"), function(i, value) {
                    var value = value.split("="), key = decodeURIComponent(value[0]);
                    2 === value.length && "string" == typeof (value = decodeURIComponent(value[1])) && value.length && (data[key] = value);
                })), data;
            }(dataUrl = $linkBtn.length && !dataUrl ? $linkBtn.attr("href") || "" : dataUrl), dataUrl = "images", plugin = params.plugin || "browser";
            if (params.mediatype ? dataUrl = params.mediatype : "files" == params.view && (dataUrl = "files"), 
            $inp.hasClass("wf-media-input-converted")) {
                try {
                    supportedExtensions = JSON.parse($(row).attr("supported-extensions") || "{}");
                } catch (e) {
                    supportedExtensions = !1;
                }
                supportedExtensions && (extensions = [], $.each(supportedExtensions, function(key, values) {
                    Array.isArray(values) && values.length && (extensions = extensions.concat(values));
                }), extensions.length) && (dataUrl = extensions.join(","));
            }
            path = "", $wrapper = ($wrapper = $($inp = $inp).parents(".field-media-wrapper")).data("fieldMedia") || $wrapper.get(0), 
            (path = (path = $wrapper ? $wrapper.options ? $wrapper.options.basepath || "" : $wrapper.basePath || "" : path) || $($inp).data("basepath") || "") && !isAdmin(path) && isAdmin(document.location.href) && (path += "administrator/");
            var path, $wrapper = path + "index.php?option=com_jce&task=plugin.display&plugin=" + plugin + "&fieldid=" + id + "&mediatype=" + dataUrl;
            options.context && (params.context = options.context);
            $.each([ "option", "task", "plugin", "fieldid", "mediatype", "element", "view", "tmpl" ], function(i, key) {
                delete params[key];
            }), $wrapper += "&" + $.param(params), $(this).data("url") && $(this).data("url", $wrapper), 
            $(this).is("joomla-field-media, .wf-media-wrapper-custom") && ($(this).attr("url", $wrapper), 
            $inp = Joomla.sanitizeHtml('<iframe src="' + $wrapper + '" class="iframe" title="" width="100%" height="100%"></iframe>', {
                iframe: [ "src", "class", "title", "width", "height" ]
            }), $(this).find(".joomla-modal").attr("data-url", $wrapper).attr("data-iframe", $inp), 
            $(this).removeAttr("modal-width").removeAttr("modal-height")), $linkBtn.length && $linkBtn.attr("href", $wrapper);
        });
    }
    function cleanInputValue(elm) {
        var val = $(elm).val() || "";
        -1 != val.indexOf("#joomlaImage") && (val = val.substring(0, val.indexOf("#")), 
        $(elm).val(val).attr("value", val));
    }
    $(document).ready(function($) {
        var options = Joomla.getOptions("plg_system_jce", {});
        function isActiveField(elm) {
            return $(elm).find(".wf-media-input-active").length;
        }
        function disableCustomElementButtons(elm) {
            elm.button && elm.button.hasAttribute("disabled") && elm.button.addEventListener("click", function(e) {
                e.preventDefault(), e.stopImmediatePropagation();
            }, !0), elm.buttonClearEl && elm.buttonClearEl.hasAttribute("disabled") && elm.buttonClearEl.addEventListener("click", function(e) {
                e.preventDefault(), e.stopImmediatePropagation();
            }, !0);
        }
        $(".wf-media-input").parents(".field-media-wrapper, .fc-field-value-properties-box").addClass("wf-media-wrapper"), 
        $(".wf-media-input-active").removeAttr("readonly"), $(".wf-media-wrapper .modal-header h3").html("&nbsp;"), 
        $(".wf-media-wrapper").find("button.button-select").on("click", function(e) {
            e.preventDefault();
        }), $(".wf-media-input").not(".wf-media-input-active").prop("disabled", !0).parent().find("button, a.btn").prop("disabled", !0).on("click", function(e) {
            e.preventDefault(), e.stopImmediatePropagation();
        }).removeAttr("onclick").hide(), $(".wf-media-input").parents(".subform-repeatable-group").each(function(i, row) {
            isActiveField(row) || $(row).parents("joomla-field-subform").find("button").hide().prop("disabled", !0).on("click", function(e) {
                e.preventDefault(), e.stopImmediatePropagation();
            });
        }), $(document).on("subform-row-add", function(evt, row) {
            evt = evt.originalEvent;
            evt && evt.detail && (row = evt.detail.row || row), 0 != $(row).find(".wf-media-input").length && (isActiveField(row) ? ($(row).find(".wf-media-input").each(function() {
                $(this).parents("joomla-field-media").addClass("wf-media-wrapper"), 
                $(this).hasClass("wf-media-input-active") && $(this).removeAttr("readonly");
            }), $(row).find("joomla-field-media.wf-media-wrapper").trigger("joomla-field-media:update"), 
            updateMediaUrl(row, options)) : ($(row).find(".wf-media-input").each(function() {
                $(this).prop("disabled", !0).parents("joomla-field-media").addClass("wf-media-wrapper");
            }), $(row).find("joomla-field-media").each(function() {
                $(this).find("button").hide().prop("disabled", !0), disableCustomElementButtons(this);
            }), $(row).parents("joomla-field-subform").find("button").hide().prop("disabled", !0).on("click", function(e) {
                e.preventDefault(), e.stopImmediatePropagation();
            })));
        }), $("joomla-field-media.wf-media-wrapper").each(function() {
            disableCustomElementButtons(this);
        }), $("joomla-field-media.wf-media-wrapper").on("joomla-field-media:update", function(e) {
            var markValidFunction, url, field = this;
            field.inputElement && (cleanInputValue(field.inputElement), markValidFunction = field.markValid || function() {}, 
            field.markValid = function() {
                cleanInputValue(this.inputElement), field.querySelector('label[for="' + this.inputElement.id + '"]') && markValidFunction.apply(this);
            }, url = field.basePath + field.inputElement.value, field.inputElement.addEventListener("change", function(e) {
                e.stopImmediatePropagation(), cleanInputValue(this), field.querySelector('label[for="' + this.id + '"]') && markValidFunction.apply(this), 
                url = field.basePath + this.value, fetch(url, {
                    method: "HEAD"
                }).then(function(res) {
                    res.ok && (res = (res.headers.get("Content-Type") || "").split(";")[0].trim(), 
                    field.mimeType = res || mimeFromExt(url));
                }).catch(function() {
                    field.mimeType = mimeFromExt(url);
                }).finally(function() {
                    createPreview(field, url, field.mimeType);
                }), $(document).trigger("t4:media-selected", {
                    selectedUrl: field.basePath + this.value
                }), $(this).trigger("change");
            }, !0), field.inputElement.value) && createPreview(field, url, field.mimeType);
        }).trigger("joomla-field-media:update").each(function() {
            updateMediaUrl(this, options);
        }), $(document).on("joomla-dialog:open", function(e) {
            var ifr, e = e.target;
            $(e).hasClass("joomla-dialog-media-field") && (ifr = e.querySelector("iframe")) && -1 != ifr.src.indexOf("index.php?option=com_jce") && $(e).addClass("wf-media-dialog");
        });
    });
}(jQuery);