<?php
/*
 * @package   bfNetwork
 * @copyright Copyright (C) 2011,2012,2013,2014,2015,2016,2017,2018,2019,2020,2021,2022,2023 Blue Flame Digital Solutions Ltd. All rights reserved.
 * @license   GNU General Public License version 3 or later
 *
 * @see       https://mySites.guru/
 * @see       https://www.phil-taylor.com/
 *
 * @author    Phil Taylor / Blue Flame Digital Solutions Limited.
 *
 * bfNetwork is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * bfNetwork is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this package.  If not, see http://www.gnu.org/licenses/
 *
 * If you have any questions regarding this code, please contact phil@phil-taylor.com
 */

class bfEvents
{
    // on viewing global config
    final public const onViewedGlobalConfig = 'bf.config.global.viewed';

    // On saving global config
    final public const onSavedGlobalConfig = 'bf.config.global.saved';

    // On viewing component options
    final public const onViewedComponentOptions = 'bf.config.component.viewed';

    // On saving component options
    final public const onSavedComponentOptions = 'bf.config.component.saved';

    // When an admin logs into /administrator/
    final public const onAdminLogin = 'bf.admin.login';

    // When an admin logs out of /administrator/
    final public const onAdminLogout = 'bf.admin.logout';

    // On viewing a user in admin
    final public const onUserViewed = 'bf.user.viewed';

    // When a user logs out
    final public const onUserLogout = 'bf.user.logout';

    // When a user is modified
    final public const onUserModified = 'bf.user.modified';

    // When a new user is created
    final public const onUserCreated = 'bf.user.created';

    // When a configured file alert file is modified
    final public const onFileModified = 'bf.file.modified';

    // When a snapshot is taken
    final public const onSnapshotTaken = 'bf.snapshot.started';

    // When an audit is started
    final public const onAuditStarted = 'bf.audit.started';

    // When an audit is finished
    final public const onAuditFinished = 'bf.audit.finished';

    // When content is searched for in com_search
    final public const onContentSearch = 'bf.search.performed';

    // when our connector is automatically upgraded
    final public const onConnectorUpgrade = 'bf.connector.upgraded';

    // when connection error resolved
    final public const onConnectorReconnect = 'bf.connector.reconnect';

    // Not going to log normal users login or logout - not a maintenance or security event
    final public const onUserLogin = 'bf.user.login';

    // @TODO
    final public const onFileDeleted = 'bf.file.deleted';

    // @TODO
    final public const onBackupStarted = 'bf.backup.started';

    // @TODO
    final public const onBackupFinished = 'bf.backup.finished';

    // @TODO
    final public const onBackupProfileChanged = 'bf.backup.profile.changed';

    // @TODO
    final public const onDowntimeStarted = 'bf.downtime.started';

    // @TODO
    final public const onDowntimeFinished = 'bf.downtime.finished';

    // @TODO
    final public const onExtensionInstall = 'bf.ext.install';

    // @TODO
    final public const onExtensionRemove = 'bf.ext.remove';

    // @TODO
    final public const onExtensionUpgrade = 'bf.ext.upgrade';

    // @TODO
    final public const onExtensionPublish = 'bf.ext.publish';

    // @TODO
    final public const onExtensionUnpublish = 'bf.ext.unpublish';

    // @TODO
    final public const onToolApplied = 'bf.tools.applied';

    // @TODO
    final public const onAlertTriggered = 'bf.alert.triggered';

    // @TODO
    final public const onSavedPluginOptions = 'bf.config.plugin.saved';
}
